
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters


////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4  position	: POSITION;
	float3  speed		: NORMAL;
	float4  colour		: COLOR;
	float2  tex0		: TEXCOORD0;
	float2  shapeVector	: TEXCOORD1;
	float2	size		: TEXCOORD2;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_planarMotionParticle( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	//new position...
	float4 normalPosition = input.position;
	output.position = input.position + float4(input.speed,0) * input.size.y;
	
	//vector...
	float2 mVector = normalize(float2(output.position.x - normalPosition.x,output.position.z - normalPosition.z));

	output.position.x = output.position.x + (mVector.x*input.size.x) - (mVector.y * input.shapeVector.y * input.size.y * input.size.x);
	output.position.z = output.position.z + (mVector.y*input.size.x) + (mVector.x * input.shapeVector.y * input.size.y * input.size.x);

	output.position = mul(output.position, shader_transform_viewProj);

	output.colour = input.colour;
	output.colour.a = output.colour.a * shader_light_diffuse.r;
	output.tex0 = input.tex0;

	return output;
}

////////////////////////////////////////////////////////////
// techniques

technique tech_planarMotionParticle_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_planarMotionParticle();	
	}
}
